unit InfoForm;

interface

uses
// --------------------------------
//     
Windows, Messages, SysUtils, Variants, Classes,
Graphics, Controls, Forms, Dialogs,
// --------------------------------
Contnrs,
ImgList, Clipbrd, Printers,
IniFiles, Registry,
Jpeg, Math,
// --------------------------------
//   Standard
Menus, StdCtrls, ActnList,
// --------------------------------
//   Additional
Buttons, Mask, Masks, Grids, ExtCtrls, {Forms, StdCtrls,}
DbLogDlg, CheckLst, AppEvnts, ValEdit,
TeeProcs, TeEngine, TeCanvas, Chart,
//   Additional (XP - )
XPStyleActnCtrls, ActnMan, ToolWin, ActnCtrls, ActnMenus,
ActnColorMaps, CustomizeDlg,
// --------------------------------
//   Win32
ComCtrls, {Controls,}
//   Win32 (XP - )
 XPMan,
// --------------------------------
//   System
{ExtCtrls,} MPlayer, OleCtnrs, DDEMan,
// --------------------------------
//   Dialogs
{Dialogs,} ExtDlgs,
// --------------------------------
//   Win31
Dblookup, Tabs, Outline, TabNotBk, {ExtCtrls,} FileCtrl,
// --------------------------------
//    Samples
Gauges, ColorGrd, Spin, DirOutln, Calendar, IBCtrls,
ShellCtrls,
// --------------------------------
//   Data Access
Db, DBClient, Provider, xmldom, Xmlxform,
// --------------------------------
//   Data Control
DBCtrls, DBGrids, DBCGrids, DbChart,
// --------------------------------
//   dbExpert
DBXpress, SqlExpr, SimpleDS,
// --------------------------------
//   DataSnap
MConnect, SConnect, ObjBrkr, TConnect,
// --------------------------------
//   BDE
DBTables,
// --------------------------------
//   ADO
ADODB,
// --------------------------------
//   InterBase
IBTable, IBQuery, IBStoredProc, IBDatabase,
IBUpdateSQL, IBCustomDataSet, IBSQL, IBDatabaseInfo,
IBSQLMonitor, IBEvents, IBExtract, DBLocal, DBLocalI,
// --------------------------------
//   WebServices
SOAPHTTPClient, SOAPHTTPTrans,
// --------------------------------
//   Internet Express
MidProd, WebBroker, DBBdeWeb,
// --------------------------------
//   Internet
HTTPProd, CGIApp, CGIHTTP, DBXpressWeb,
Sockets, SHDocVw,
// --------------------------------
//   WebSnap
WebAdapt, WebComp, DBAdapt, WebDisp, WebUsers, XMLIntf,
msxmldom, XMLDoc, XSLProd, CompProd, PagItems, SiteProd,
// --------------------------------
//   Decision Cube
Mxstore, MXDB, MXTABLES, MXPIVSRC, MXGRID, MXGRAPH,
// --------------------------------
//   ActiveX (OLE 2 Interface Unit)
ActiveX, ComObj, AxCtrls, OleCtrls, OleConst,
Chartfx3, VCSpell3, VCF1, VCFI,
// --------------------------------
//   Rave
RpDefine, RpRave, RpBase, RpSystem, RpFiler, RpCon,
RpConDS, RpConBDE, RpRender, RpRenderCanvas, RpRenderPreview,
RpRenderPrinter, RpRenderPDF, RpRenderHTML, RpRenderRTF,
RpRenderText,
// --------------------------------
//   Indy Clients
IdBaseComponent, IdComponent, IdTCPConnection,  IdTCPClient,
IdIntercept, IdIOHandler, IdDayTime, IdUDPBase, IdUDPClient,
IdDayTimeUDP, IdDNSResolver, IdEcho, IdEchoUDP,
IdFinger, IdFTP, IdGopher, IdHTTP, IdCookieManager,
IdHTTPHeaderInfo, IdHeaderList,  IdRawBase, IdRawClient,
IdIcmpClient, IdMessageClient, IdIMAP4, IdPOP3, IdIdent,
IdIPMCastBase, IdIPMCastClient, IdSocketHandle, IdIRC,
IdLPR, IdNNTP, IdQotd, IdQOTDUDP, IdRemoteCMDClient,
IdRexec, IdRSH, IdSMTP, IdSNMP, IdSNPP, IdSNTP, IdSysLog,
IdTelnet, IdTime, IdTimeUDP, IdTrivialFTP, IdWhois,
//   Indy Servers
IdTCPServer, IdRFCReply, IdServerIOHandler, IdThreadMgr,
IdUDPServer, IdChargenServer, IdChargenUDPServer,
IdDayTimeServer, IdDayTimeUDPServer, IdDICTServer, IdDiscardServer,
IdDiscardUDPServer, IdEchoServer, IdEchoUDPServer, IdFingerServer,
IdFTPServer, IdUserAccounts, IdGopherServer, IdHTTPServer,
IdIdentServer, IdIMAP4Server, IdIPMCastServer, IdIRCServer,
IdMappedPortTCP, IdMappedFTP, IdMappedPortUDP, IdNNTPServer,
IdPOP3Server, IdQOTDServer, IdQotdUDPServer, IdRexecServer,
IdRSHServer, IdSimpleServer, IdSMTPServer, IdSyslogServer,
IdTelnetServer, IdTimeServer, IdTimeUDPServer, IdTrivialFTPServer,
IdTunnelMaster, IdTunnelSlave,
// --------------------------------
//   Indy Intercepts
IdBlockCipherIntercept, IdCompressionIntercept, IdLogDebug,
IdLogEvent, IdLogFile, IdLogStream,
// --------------------------------
//   Indy I/O Handlers
IdSocks, IdIOHandlerSocket, IdIOHandlerStream, IdIOHandlerThrottle,
IdServerIOHandlerSocket, IdSSLOpenSSL,
// --------------------------------
//   Indy Misc
IdAntiFreeze, IdCoder, IdCoder3to4, IdCoderMIME, IdCoderUUE,
IdCoderQuotedPrintable, IdDateTimeStamp, IdCoderXXE,
IdIPWatch, IdHL7, IdMailBox, IdMessage, IdEMailAddress,
IdMessageCoder, IdMessageCoderMIME, IdNetworkCalculator,
IdSysLogMessage, IdThreadComponent, IdThreadMgrDefault,
IdThreadMgrPool, IdVCard,
// --------------------------------
//   COM+
OleServer, CmAdmCtl,
// --------------------------------
//   InterBase Admin
IBServices, IBInstall,
// --------------------------------
//   IW Standard, IW Data, IW CLient Side
// IW Client Control  ,   
//    .
// --------------------------------
//   Servers
Word2000, Excel2000, MSPpt2000,
Outlook2000, Access2000, Binder2000,
//------------------------------
// 
ScktComp, ComServ, syncobjs, httpapp, dbweb,  DsIntf,
Nsapi, Isapi, isapiapp, ISAPIHTTP, MidasCon,

//------------------------------
{DesignIntf, DesignEditors,}
//------------------------------

TypInfo,
StrUtils,
About
;

type
TForm1 = class(TForm)
    Panel1: TPanel;
    LBoxFamilyTree: TListBox;
    StringGrid1: TStringGrid;
    STextRepTitle: TStaticText;
    LBoxSimpleInfo: TListBox;
    Panel2: TPanel;
    TreeView1: TTreeView;
    ImageList1: TImageList;
    PopupMenu1: TPopupMenu;
    PUM1Select: TMenuItem;
    PUM1DeSelect: TMenuItem;
    Label1: TLabel;
    SButtTreeBuild: TSpeedButton;
    SButtTreeSort: TSpeedButton;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Edit1: TEdit;
    SButtFindClass: TSpeedButton;
    Label6: TLabel;
    PUM1SaveToFile: TMenuItem;
    MainMenu1: TMainMenu;
    MM1Files: TMenuItem;
    N5: TMenuItem;
    MM1About: TMenuItem;
    MM1BuildTree: TMenuItem;
    MM1SortTree: TMenuItem;
    MM1SaveTreeToFile: TMenuItem;
    MM1Exit: TMenuItem;
    MM1ExpandAll: TMenuItem;
    MM1ColapceAll: TMenuItem;
    Panel3: TPanel;
    Panel4: TPanel;
    ProgressBar1: TProgressBar;
    StatusBar1: TStatusBar;
    procedure TreeView1Change(Sender: TObject; Node: TTreeNode);
    procedure StringGrid1Click(Sender: TObject);
    procedure PUM1SelectClick(Sender: TObject);
    procedure PUM1DeSelectClick(Sender: TObject);
    procedure SButtTreeBuildClick(Sender: TObject);
    procedure SButtTreeSortClick(Sender: TObject);
    procedure SButtFindClassClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure PUM1SaveToFileClick(Sender: TObject);
    procedure MM1BuildTreeClick(Sender: TObject);
    procedure MM1SortTreeClick(Sender: TObject);
    procedure MM1SaveTreeToFileClick(Sender: TObject);
    procedure MM1ExitClick(Sender: TObject);
    procedure MM1ExpandAllClick(Sender: TObject);
    procedure MM1ColapceAllClick(Sender: TObject);
    procedure MM1AboutClick(Sender: TObject);

private
   { Private declarations }
   procedure BuildTree();
   procedure SortTree();
public
   { Public declarations }
end;

var
Form1: TForm1;

implementation
{$R *.DFM}

const MaxIndex = 811 - 40;
type  TClassArray = array [1..MaxIndex] of TClass;
const ClassArray: TClassArray = (

// =======================================================================
//  
TObject, SysUtils.Exception, TPersistent, TComponent, TControl, TWinControl,
TApplication, TApplicationEvents,
// =======================================================================
//   Exception
EAbort, EAccessViolation, EAssertionFailed, EBitsError, EClassNotFound,
EComponentError, EControlC, EConvertError, EDatabaseError, EDateTimeError,
EDBClient, EDBEditError, EDBEngineError, EDivByZero, EExternalException,
EFCreateError, EFilerError, EFOpenError, EIBError, EInOutError,
EIntError, EIntfCastError, EIntOverflow, EInvalidArgument, EInvalidCast,
EInvalidContainer, EInvalidGraphic, EInvalidGraphicOperation,
EInvalidGridOperation, EInvalidImage, EInvalidInsert, EInvalidOp,
EInvalidOperation, EInvalidPointer, EListError, EMathError,
EMCIDeviceError, EMenuError, EMethodNotFound, ENoResultSet,
EOleCtrlError, EOleError, EOleException, EOleException, EOleSysError,
EOutlineError, EOutOfMemory, EOutOfResources, EOverflow, EPackageError,
EParserError, EPrinter, EPrivilege, EPropertyError, EPropReadOnly,
EPropWriteOnly, ERangeError, EReadError, EReconcileError, ERegistryException,
EResNotFound, ESocketError,  EStreamError, EStringListError,
EThread, ETreeViewError, EUnderflow, EUpdateError, EVariantError,
EWriteError, EZeroDivide,
{Deprecated}
EStackOverflow, EWin32Error,
// =======================================================================
//  ,    
//         
//   .

{System}
 TAggregatedObject, TContainedObject, TInterfacedObject,

{Classes}
 TCustomMemoryStream, TBits, TCollection, TCollectionItem, TDataModule,
 TFiler, TFileStream, THandleStream, TMemoryStream, TList, TParser,
 TReader, TResourceStream, TStream, TStringList, TStrings, TStringStream,
 TThread, TThreadList, TWriter, TBasicAction,

{Graphics}
 TGraphic, TGraphicsObject, TBitmap, TBitmapImage, TBrush,  TCanvas,
 TFont, TIcon, TIconImage, TMetafile, TMetafileCanvas, TMetafileImage,
 TPen, TPicture, TSharedImage,

{Controls, Tabs}
 TCustomControl, TControlCanvas, TDragControlObject, TGraphicControl,
 THintWindow,  TDragObject,  TSizeConstraints,
 TScroller, TTabSet, TTabList,

{Dialogs, ExtDlgs}
 TColorDialog, TCommonDialog, TFontDialog, TFindDialog, TOpenDialog,
 TPrintDialog, TPrinterSetupDialog, TReplaceDialog, TSaveDialog,
 TOpenPictureDialog, TSavePictureDialog,

{ComCtrls}
  TCustomTabControl, TCustomRichEdit, TCustomTreeView,
  TCustomUpDown, TConversion, TDateTimeColors, THeaderSection,
  THeaderSections, TIconOptions, TListColumn, TParaAttributes,
  TTabSheet, TTextAttributes,

 //--------------------------------------------------------------------
 {SyncObjs}
 TCriticalSection, TEvent, THandleObject, TSimpleEvent, TSynchroObject,

 {ScktComp}
 TCustomSocket, TCustomWinSocket, TCustomServerSocket,
 TClientSocket, TClientWinSocket, TServerAcceptThread,
 TServerClientThread, TServerClientWinSocket, TServerSocket,
 TServerWinSocket,

 {DBWeb}
 TDSTableProducer, TDSTableProducerEditor,
 TDataSetTableProducer, THTMLTableColumn, THTMLTableColumns, THTTPDataLink,

 {FileCtrl}
 TDirectoryListBox, TFileListBox,  TFilterComboBox, TDriveComboBox,
 TIniFile, TISAPIApplication,

 {Registry}
 TRegistry, TRegIniFile,

 {Provider}
 TCustomProvider, TProvider,

{HTTPApp}
 TCustomWebDispatcher, TWebActionItem, TWebActionItems, TWebDispatcher,
 TWebModule, TWebRequest, TWebResponse,

{==========  ===========}
 {Contnrs}
 TComponentList,
 {ImgList}
 TCustomImageList,  TChangeLink,
 {Printer,}
 TPrinter,
 {Variants}
 TCustomVariantType,
 {JPeg}
 TJPEGImage,

 {Outline - Deprecated}
 TCustomOutline, TOutline, TOutlineNode, OutlineError,

 {TabNotBk}
 TTabbedNotebook, TTabPage,

 // -------------------
 TComServer,
 TRemoteServer,

 // ==========================
 {ISAPI}
 TISAPIRequest,
 TISAPIResponse,
// -------------------
 {WebBroker}
 TWebApplication,
 TWinCGIRequest,
 TWinCGIResponse,
 {CGIApp}
 TCGIApplication,
 {CGIHTTP}
 TCGIRequest,
 TCGIResponse,
 // -------------------

 // ===================
 //   Standard
 {Forms}
 TCustomForm, TForm, TScreen, TScrollingWinControl, TControlScrollBar,
 TFrame, TScrollBox,
 {Menu}
 TMainMenu, TPopupMenu, TMenu, TMenuItem,
 {StdCtrls}
 TLabel,  TEdit, TMemo, TButton, TCheckBox,
 TListBox, TComboBox, TScrollBar,  TGroupBox,
 {StdCtrls}
 TCustomMemo, TCustomEdit, TCustomCheckBox, TCustomComboBox,
 TCustomGroupBox,  TCustomLabel, TCustomListBox,
 TCustomCheckBox, TCustomComboBox, TButtonControl, TRadioButton,
 {ExtCtrls}
 TCustomPanel, TCustomRadioGroup, TRadioGroup, TPanel,
 {ActnList}
 TActionList,
 // ===================
 //   Additional
 {Buttons, Masks}
 TBitBtn, TSpeedButton, TMask, TCustomMaskEdit, TMaskEdit,
 {Grids}
 TCustomGrid, TStringGrid, TDrawGrid, TInplaceEdit,
 TStringGridStrings,
 {StdCtrls}
 TCustomStaticText, TStaticText,
 {ExtCtrls}
 TImage, TShape, TBevel, TSplitter,  TControlBar,
 THeader, TNotebook, TLabeledEdit, TColorBox,
 {ValEdit}
 TValueListEditor,
 {Chart}
 TChart,  TChartWall,  TChartTitle, TChartLegend, TChartAxis,
 TChartGradient,  TChartPen, TChartBrush, TChartAxisPen,
 TDottedGrayPen, TChartHiddenPen, TDarkGrayPen, TChartAxisTitle,
 {CheckLst}
 TCheckListBox,
 {ActnMan} {-}
 TActionManager, TActionBars, TActionListCollection, TActionBarStyle,
 TActionMainMenuBar, TActionToolBar, TXPColorMap, TStandardColorMap,
 TTwilightColorMap, TCustomizeDlg,
 TXPManifest,
 // ===================
 //   Win32
 TTabControl, TPageControl, TPage, TImageList, TListColumns,
 TListItem, TListItems, TListView, TRichEdit,  TTrackBar,
 TProgressBar, TUpDown, THotKey, TAnimate,  TDateTimePicker,
 TMonthCalendar, TTreeView, TTreeNode, TTreeNodes, THeaderControl,
 TStatusBar, TStatusPanel, TStatusPanels, TToolBar, TToolButton,
 TCoolBar, TCoolBand, TPageScroller, TComboBoxEx, TComboExItems,
 {*Customs}
 TCustomListView, TCustomHotKey,
 // ===================
 //   System
 TTimer, TPaintBox, TMediaPlayer,
 {OleCtnls, OleCtrls}
 TOleContainer, TOleForm, TOleControl, TEnumPropDesc,  TEventDispatch,
 {Clpbrd}
 TClipboard,
 {DBeMan}
 TDdeClientConv, TDdeClientItem, TDdeMgr, TDdeServerConv,
 TDdeServerItem,
 // ===================
 //   Data Access
 {DB}
 TAutoIncField,  TBinaryField,  TBlobField, TBooleanField, TBytesField,
 TCheckConstraint, TCheckConstraints, TCurrencyField, TBCDField,
 TDataLink, TDataSource, TDataSet, TDataSetDesigner, TDateField,
 TDateTimeField, TField, TFieldDef, TFieldDefs, TFloatField, TGraphicField,
 TIndexDef, TIndexFiles, TMemoField, TIntegerField, TNumericField,
 TParam, TParams, TSmallintField, TStringField,  TTimeField,
 TVarBytesField, TWordField, TLookupList, TLoginDialog,
 {DBClient}
 TCustomRemoteServer, TClientDataSet, TConnectionBroker,
 {Xmlxform}
 TXMLTransformProvider, TXMLTransform, TXMLTransformClient,
 // ===================
 //   Data Controls
 {DBCtrls}
 TDBNavigator, TNavButton,  TNavDataLink,
 TDBText, TDBEdit, TDBMemo, TDBImage,  TDBListBox, TDBComboBox,
 TDBCheckBox, TDBRadioGroup, TDBLookupListBox, TDBLookupComboBox,
 TDBRichEdit, TDBLookupControl, TDataSourceLink, TFieldDataLink,
 TListSourceLink, TPaintControl, TPopupDataList,
 {DBGrids}
 TCustomDBGrid, TDBGrid, TDBCtrlPanel,  TDBCtrlGridLink,
 TDBGridColumns, TBookmarkList, TColumn, TColumnTitle, TGridDataLink,
 {DBCGrids, DBChart}
 TDBCtrlGrid, TDBChart,
 {DBTables}
 TDBDataSet, TDBError,
 {DbLookUp}
 TDBLookupCombo, TDBLookupList, TPopupGrid, TComboButton,

 // ===================
 //   DataSnap
 {SqlExpr}
 TSQLConnection, TSQLDataSet, TSQLQuery, TSQLStoredProc, TSQLMonitor,
 {SimpleDS}
 TSimpleDataSet,
 {MConnect, SConnect, TConnect }
 TDCOMConnection, TSharedConnection,
 TSocketConnection, TWebConnection,
 TLocalConnection,
 {ObjBrkr}
 TSimpleObjectBroker,

 // ===================
 //   BDE
 {DBTables}
 TDatabase, TBatchMove, TBDECallback, TBDEDataSet,
 TBlobStream, TDataSetUpdateObject, TParamList, TQuery,
 DBTables.TSession, TSessionList, TStoredProc, TTable, TUpdateSQL,

 // ===================
 //   ADO
 TADOConnection, TADOCommand, TADODataSet, TADOTable,
 TADOQuery, TADOStoredProc, TRDSConnection,

 // ===================
 //   InterBase Admin
 TIBComponent,
 TIBTable,
 TIBQuery,
 TIBStoredProc,
 TIBDatabase,
 TIBTransaction,
 TIBUpdateSQL,
 TIBDataSet,
 TIBSQL,
 TIBDatabaseInfo,
 TIBSQLMonitor,
 TIBEvents,
 TIBExtract,
 TIBClientDataSet,
 TAggregates,
 TIBGeneratorField,
 TServerCollection,
 //
 TAdapter,
 TPagedAdapter,
 TDataSetAdapter,
 TLoginFormAdapter,
 TAdapterDefaultFields,
 TAdapterDefaultActions,
 TStringsValuesList,
 TDataSetValuesList,
 TWebAppComponents,
 TApplicationAdapter,
 TEndUserAdapter,
 TEndUserSessionAdapter,
 TPageDispatcher,
 TAdapterDispatcher,
 TLocateFileService,
 TWebUserList,
 TWebUserItems,
 TXSLPageProducer,
 TDOMVendor,
 TAdapterPageProducer,
 TWebComponentList,

 // ===================
 //   Decision Cube
 TDecisionCube,
 TCubeDims,
 TDecisionQuery,
 TDecisionSource,
 TDecisionPivot,
 TDecisionGrid,
 TDisplayDims,
 TDecisionGraph,


 // ===================
 //   Internet
 TPageProducer, TCustomPageProducer,  THTMLTableAttributes,
 THTMLTableCellAttributes, THTMLTableElementAttributes,
 THTMLTableHeaderAttributes, THTMLTableRowAttributes,
 THTMLTagAttributes, TQueryTableProducer, TSQLQueryTableProducer,
 TTcpClient,  TTcpServer, TUdpSocket, TXMLDocument, TWebBrowser,

 // ===================
 //   Samples
 TGauge, TSpinButton, TColorGrid, TSpinEdit, TTimerSpeedButton,
 TDirectoryOutline, TCalendar, TIBEventAlerter, TShellTreeView,
 TShellComboBox, TShellListView, TShellChangeNotifier,
 
 // ===================
 //   ActiveX
 TChartfx,
 TVSSpell,
 TF1Book,
 TVtChart,
 AxCtrls.TPropertyPage,
 TOleGraphic, TOleStream, TConnectionPoint, TConnectionPoints,
 TCustomAdapter, TPictureAdapter, TStringsAdapter, TFontAdapter,
 TActiveForm, TActiveFormControl, TActiveFormFactory,
 TActiveXControl, TActiveXControlFactory, TActiveXPropertyPage,
 TActiveXPropertyPageFactory, TAdapterNotifier,

 // ===================
 //   Rave
 TRvProject, TRvSystem, TSystemFiler, TSystemPreview, TSystemPrinter,
 TRvNDRWriter, TRvCustomConnection, TRvDataSetConnection,
 TRvTableConnection, TRvQueryConnection, TRvRenderPreview,
 TRvRenderPrinter, TRvRenderPDF, TRPPDFDocInfo, TRvRenderHTML,
 TRvRenderRTF, TRvRenderText,

 // ===================
 // INDY
 //   Indy Clients
 TIdTCPClient, TIdConnectionIntercept,  TIdIOHandler,  TIdUDPClient,
 TIdDayTime,  TIdDayTimeUDP,  TIdDNSResolver,  TIdEcho,   TIdEchoUDP,
 TIdFinger,  TIdFTP, TIdFtpProxySettings, TIdGopher,  TIdHTTP,
 TIdHTTPRequest, TIdHeaderList, TIdCookieManager, TIdProxyConnectionInfo,
 TIdIcmpClient, TIdIdent, TIdIMAP4, TIdIPMCastClient, TIdSocketHandles,
 TIdIRC, TIdIRCReplies, TIdLPR, TIdLPRControlFile, TIdNNTP, TIdPOP3,
 TIdQOTD, TIdQOTDUDP, TIdRexec, TIdRSH, TIdSMTP, TIdSNMP, TIdSNPP,
 TIdSNTP, TIdSysLog, TIdTelnet, TIdTime, TIdTimeUDP, TIdTrivialFTP,
 TIdWhois,
//   Indy Servers
 TIdTCPServer, TIdCommandHandlers, TIdRFCReply, TIdRFCReplies,
 TIdServerIntercept, TIdServerIOHandler, TIdThreadMgr,
 TIdUDPServer, TIdChargenServer, TIdChargenUDPServer,
 TIdDayTimeServer, TIdDayTimeUDPServer, TIdDICTServer,
 TIdDISCARDServer, TIdDiscardUDPServer, TIdECHOServer,
 TIdEchoUDPServer, TIdFingerServer, TIdFTPServer,
 TIdUserManager, TIdUserAccounts, TIdGopherServer,
 TIdHTTPServer, TIdIdentServer, TIdIMAP4Server,
 TIdIPMCastServer, TIdIRCServer, TIdMappedFTP, TIdMappedPop3,
 TIdMappedPortTCP, TIdMappedPortUDP, TIdMappedTelnet,
 TIdNNTPServer, TIdPOP3Server, TIdQOTDServer, TIdQotdUDPServer,
 TIdRexecServer, TIdRSHServer, TIdSimpleServer, TIdSMTPServer,
 TIdSMTPMessages,  TIdSMTPGreeting, TIdSMTPRcpReplies,
 TIdSMTPDataReplies, TIdSyslogServer, TIdTelnetServer,
 TIdTimeServer, TIdTimeUDPServer, TIdTrivialFTPServer,
 TIdTunnelMaster, TIdTunnelSlave,
//   Indy Intercepts
 TIdBlockCipherIntercept, TIdConnectionIntercept,
 TIdCompressionIntercept, TIdLogDebug, TIdLogEvent,
 TIdLogFile, TIdLogStream,
//   Indy I/O Handlers
 TIdIOHandlerSocket, TIdSocksInfo, TIdIOHandlerStream,
 TIdIOHandlerThrottle, TIdServerIOHandlerSocket,
 TIdServerIOHandlerSSL, TIdSSLOptions, TIdSSLIOHandlerSocket,
//   Indy Misc
 TIdSocksInfo, TIdAntiFreeze, TIdCookieManager,
 TIdEncoderMIME, TIdEncoderUUE, TIdEncoderQuotedPrintable,
 TIdDateTimeStamp, TIdDecoderMIME, TIdDecoderUUE,
 TIdDecoderXXE, TIdDecoderQuotedPrintable,
 TIdIPWatch, TIdHL7, TIdMailBox, TIdMessage, TIdEMailAddressList,
 TIdEMailAddressItem, TIdMessageDecoderMIME, TIdNetworkCalculator,
 TIpProperty, TIdSysLogMessage, TIdSysLogMsgPart, TIdThreadComponent,
 TIdThreadMgrDefault, TIdThreadMgrPool, TIdUserManager,
 TIdVCard, TIdVCardName, TIdVCardEMailAddresses, TIdVCardTelephones,
 TIdVCardBusinessInfo, TIdVCardAddresses, TIdVCardMailingLabels,
 TIdVCardEmbeddedObject,

 // ===================
 //   COM+
 TCOMAdminCatalog,
 {ComObj}
 TAutoIntfObject, TAutoObject, TAutoObjectFactory, TComClassManager,
 TComObject, TComObjectFactory, TComServerObject, TTypedComObject,
 TTypedComObjectFactory,

 // ===================
 //   InterBase Admin
 TIBConfigService, TIBBackupService, TIBRestoreService,
 TIBValidationService, TIBStatisticalService, TIBLogService,
 TIBSecurityService, TIBServerProperties, TIBLicensingService,
 TIBInstall, TIBUnInstall, TInstallOptions,

 // ===================
 //   Servers
 TWordApplication, TWordDocument, TWordFont,
 TWordLetterContent, TWordParagraphFormat,
 TExcelApplication, TExcelQueryTable, TExcelChart,
 TExcelWorksheet, TExcelWorkbook, TExcelOLEObject,
 TPowerPointApplication, TPowerPointSlide,
 TPowerPointPresentation, TMaster,
 TOutlookApplication, TContactItem, TDistListItem,
 TDocumentItem, TExplorers, TInspectors, TFolders,
 TItems, TJournalItem, TNameSpace, TOutlookBarGroups,
 TOutlookBarPane, TOutlookBarShortcuts,
 TPostItem, TRemoteItem, TReportItem,
 TTaskRequestAcceptItem, TTaskRequestDeclineItem,
 TTaskRequestItem, TTaskRequestUpdateItem, TSyncObject,
 TAccessApplication, TAccessForm, TAccessReport,
 TAccessReferences, TClass_, TBinder,

 // ===================
 // ===================


// UNITS  DesignIntf, DesignEditors,
{
 TBoolProperty, TFloatProperty, TOrdinalProperty,  TIntegerProperty,
 TEnumProperty, TCharProperty, TStringProperty,  TDateProperty,
 TTimeProperty, TSetElementProperty, TSetProperty, TClassProperty,
 TComponentProperty, TComponentNameProperty, TMethodProperty,
 TPropertyEditor,
 }
 // UNITS DesignIntf, DesignEditors,
 {
 TComponentEditor, TCustomModule, TDefaultEditor, TIComponentInterface,
 TIEditorInterface, TIEditReader, TIEditView, TIEditWriter,
 TIExpert, TIFileStream, TIFormInterface, TIMainMenuIntf,
 TIMemoryStream, TIMenuItemIntf, TIModuleCreator, TIModuleInterface,
 TIModuleNotifier, TInterface, TIProjectCreator, TIResourceEntry,
 TIResourceFile, TIStreamAdapter, TIToolServices, TVirtualStream,
}
// ===================
TWinSocketStream
);

var SList : TStringList;

// =========================================================================
//      UNIT TypInfo
// =========================================================================
//       
procedure ShowClassProrerty (PListProp : PPropList;
                             PropCount : Integer;
                             Report    : TStringGrid);
const TitArr : array[0..3] of string =
             ('Kind', ' ', ' ', 'Unit');
var   Ind    : integer;
      WStr   : string;
      ATypeData  : PTypeData;  //     
begin
  //      
  if not (Assigned(PListProp) and (PropCount > 0))
  then begin
     //   
     Report.FixedRows := 1;
     Report.RowCount  := 2;
     for Ind := Low(TitArr) to High(TitArr)
     do begin
       Report.Cells[Ind,0] := TitArr[Ind];
       Report.Cells[Ind,1] := '';
     end;
  end
  else begin
     //   
     Report.RowCount   := PropCount + 1;
     Report.FixedRows  := 1;
     for Ind := Low(TitArr) to High(TitArr)
     do  Report.Cells[Ind,0] := TitArr[Ind];
     //  
     for Ind := 0 to PropCount - 1 do
     begin
        //   
        WStr := GetEnumName(TypeInfo(TTypeKind),
                            Integer(PListProp^[Ind].PropType^.Kind));
        Report.Cells[0, Ind + Report.FixedRows] := Wstr;
        //    
        Report.Cells[1, Ind + Report.FixedRows] := PListProp^[Ind].Name;
        //    
        Report.Cells[2, Ind + Report.FixedRows] := PListProp^[Ind].PropType^.Name;
        //     ,    Unit   
        Report.Cells[3, Ind + Report.FixedRows] := '';
        //       
        ATypeData  := GetTypeData(PListProp^[Ind].PropType^);
        if Assigned (ATypeData)
        then begin
          if (PListProp^[Ind].PropType^.Kind = tkClass)
          then begin
               //   Unit
               Report.Cells[3, Ind + Report.FixedRows] := ATypeData^.UnitName;
          end;
        end;
     end;
  end;
end;

//       
procedure EnumClassProrerty(RqClass  : TClass;
                            RepTitle : TStaticText;
                            RepList  : TStringGrid);
var
  ATypeInfo  : PTypeInfo;  //   
  ATypeData  : PTypeData;  //     
  PropCount  : Integer;    //  
  PListProp  : PPropList;  //   
  EnProp     : boolean;    //  -  
begin
  EnProp     := False;
  PListProp  := nil;
  //        
  ATypeInfo  := PTypeInfo(RqClass.ClassInfo);
  if Assigned(ATypeInfo)
  then begin
     ATypeData  := GetTypeData(ATypeInfo);
     if Assigned (ATypeData)
     then begin
       EnProp   := True;
       //     
       PropCount  := ATypeData^.PropCount;
       if PropCount > 0 then
       begin
          GetMem(PListProp, PropCount * SizeOf(Pointer));
          //    
          GetPropInfos(ATypeInfo, PListProp);
          //   
          ShowClassProrerty(PListProp, PropCount, RepList);
          FreeMem(PListProp, PropCount * SizeOf(Pointer));
       end
       else ShowClassProrerty(PListProp, PropCount, RepList);
       //  
       RepTitle.Caption := ' Unit : '
                         + ATypeData^.UnitName
                         + ',  : ' + RqClass.ClassName
                         + ',   : '
                         + IntToStr(PropCount);
     end;
  end;
  if not EnProp
  then begin
     RepTitle.Caption := ' ' + RqClass.ClassName
                       + ' :  ';
     ShowClassProrerty(nil, 0, RepList);
  end;
end;

// =========================================================================
//   (TTreeView)      ClassArray
// =========================================================================
//   RqTree ,    RqClass
function SeekClassNode (RqTree : TTreeView; RqClass: TClass): TTreeNode;
var wNode : TTreeNode;
begin
  //      
  Result := nil;                   //  -   
  with RqTree do
  begin
    wNode := Items.GetFirstNode;   //   
    while wNode <> nil do
    begin
       if wNode.Data = pointer(RqClass) then
       begin
          //       
          //     (RqClass).  
          Result := wNode;
          Exit;
       end;
       wNode := wNode.GetNext;     //   
    end;
  end;  // of with RqTree
end;

//   RqTree      RqClass.
function AddClassNode (RqTree : TTreeView;  RqClass: TClass): TTreeNode;
var ParentNode: TTreeNode;
begin
  //  ,    RqClass
  Result := SeekClassNode (RqTree, RqClass);
  with RqTree do
  begin
    if Result = nil then
    //   RqClass  ,   
    begin
       //   ,   
       // .      
       //  SeekClassNode,    
       //  AddChildObject.
       ParentNode := AddClassNode (RqTree, RqClass.ClassParent);
       //        
       // Result :  (TTreeNode)   
       Result := RqTree.Items.AddChildObject (
                ParentNode,          //   
                RqClass.ClassName,   //   
                Pointer (RqClass));  //    
       // 
       // SList.Add(RqClass.ClassName + ',');
    end;
  end;
end;

//   ,    RqTreeView
procedure MakeClassTree(RqTree        : TTreeView;
                        RqProgressBar : TProgressBar);
var Ind : integer;
begin
  RqProgressBar.Min := Low (ClassArray);
  RqProgressBar.Max := High (ClassArray);
  //      TObject
  RqTree.Items.AddObject (nil, 'TObject', Pointer (TObject));
  //         ClassArray
  for Ind := Low (ClassArray) to High (ClassArray) do
  begin
     //     
     AddClassNode (RqTree, ClassArray [Ind]);
     RqProgressBar.Position := Ind;
  end;
  RqProgressBar.Position := RqProgressBar.Min;
end;

// =========================================================================
//     
// =========================================================================
//      RqClass
procedure SimpleClassInfo (RqClass  : TClass;
                           RqReport : TListBox);
begin
   RqReport.Clear;
   RqReport.Items.Add('  : ' + RqClass.ClassName);
   RqReport.Items.Add('    : '
                     + IntToStr(RqClass.InstanceSize));
   if RqClass.InheritsFrom(TComponent)
   then RqReport.Items.Add('  ')
   else RqReport.Items.Add('   ');
   if RqClass.ClassParent <> nil
   then RqReport.Items.Add('  : '
                     + RqClass.ClassParent.ClassName)
   else RqReport.Items.Add('  ');
end;

//    RqClass
procedure ShowFamilyTree (RqClass : TClass; RqReport : TListBox);
var wClass : TClass;
begin
   wClass := RqClass;
   with RqReport.Items do
   begin
      Clear;
      while wClass.ClassParent <> nil do
      begin
        wClass := wClass.ClassParent;
        Add (wClass.ClassName);
      end;
   end;
end;

//   ,    TreeView
procedure TForm1.BuildTree();
begin
  //   
  SButtTreeBuild.Enabled := False;
  MM1BuildTree.Enabled := False;
  Forms.Screen.Cursor := crHourglass;
  StatusBar1.Panels[1].Text := '   ';
  StatusBar1.Repaint;
  //   ,    RqTreeView
  MakeClassTree(TreeView1, ProgressBar1);
  //       
  StatusBar1.Panels[0].Text := '   : '
                            + IntToStr(TreeView1.Items.Count);
  //   
  SButtTreeSort.Enabled := True;
  MM1SortTree.Enabled := True;
  MM1SaveTreeToFile.Enabled := True;
  Forms.Screen.Cursor := crDefault;
  StatusBar1.Panels[1].Text := '    ';
end;

//  
procedure TForm1.SortTree();
begin
  //  
  Forms.Screen.Cursor := crHourglass;
  TreeView1.SortType := stText;
  Forms.Screen.Cursor := crDefault;
  SButtTreeSort.Enabled := False;
  MM1SortTree.Enabled := False;
end;

// -----------------------------------------------------------------------
//    ( 1)
// -----------------------------------------------------------------------
//     (   )
procedure TForm1.TreeView1Change (Sender: TObject; Node: TTreeNode);
var wClass : TClass;
begin
  //    
  wClass := TClass (Node.Data);
  //    
  SimpleClassInfo (wClass, LBoxSimpleInfo);
  //    RqClass
  ShowFamilyTree (wClass, LBoxFamilyTree);
  //     
  EnumClassProrerty(wClass, STextRepTitle, StringGrid1);
  TreeView1.SetFocus;
end;

//   ,    TreeView
procedure TForm1.SButtTreeBuildClick(Sender: TObject);
begin
  BuildTree();
end;
//   ,    TreeView
procedure TForm1.MM1BuildTreeClick(Sender: TObject);
begin
  BuildTree();
end;
//   
procedure TForm1.SButtTreeSortClick(Sender: TObject);
begin
  SortTree();
end;
//   
procedure TForm1.MM1SortTreeClick(Sender: TObject);
begin
  SortTree();
end;
//    
procedure TForm1.MM1ExpandAllClick(Sender: TObject);
begin
 TreeView1.FullExpand;
end;
//    
procedure TForm1.MM1ColapceAllClick(Sender: TObject);
begin
 TreeView1.FullCollapse;
end;
//      *.txt
procedure TForm1.MM1SaveTreeToFileClick(Sender: TObject);
begin
  if MessageDlg('    '
                  + #13 + '  : .\Trees\AllClasses.txt',
     mtConfirmation, [mbYes, mbNo], 0) = mrYes
  then begin
     TreeView1.SaveToFile('.\Trees\AllClasses.txt');
  end;
end;

// =========================================================================
// 
// =========================================================================
//   RqTree ,    RqClass
function SeekByNameClassNode(RqTree : TTreeView; RqName: string): TTreeNode;
var wNode : TTreeNode;
begin
  //      
  Result := nil;                   //  -   
  with RqTree do
  begin
    wNode := Items.GetFirstNode;   //   
    while wNode <> nil do
    begin
       if wNode.Text = RqName then
       begin
          //       
          //     (RqClass).  
          Result := wNode;
          Exit;
       end;
       wNode := wNode.GetNext;     //   
    end;
  end;  // of with RqTree
end;

//         
procedure ExpandNode(RqNode : TTreeNode);
begin
  if RqNode <> nil
  then begin
    RqNode.Selected := True;       //  
    RqNode.StateIndex := 1;        //    
    RqNode.Expand(True);           //   
    RqNode.TreeView.SetFocus;      //    
  end;
end;

//    ,  ,     
procedure SeekByNameAndExpandNode(RqTree : TTreeView; RqName: string);
var wNode : TTreeNode;
begin
  wNode := SeekByNameClassNode(RqTree, Trim(RqName));
  if wNode <> nil
  then begin
    ExpandNode(wNode);
  end
  else MessageDlg(Trim(RqName) + '    ...',
                   mtInformation, [mbOk], 0);
end;

// -----------------------------------------------------------------------
//    ( 2)
// -----------------------------------------------------------------------
//     Grid 
procedure TForm1.StringGrid1Click(Sender: TObject);
var wNode : TTreeNode;
begin
  with StringGrid1 do
  begin
    if Trim(Cells[0,Row]) = 'tkClass'
    then begin
        //     
        wNode := SeekByNameClassNode(TreeView1, Trim(Cells[2,Row]));
        if wNode <> nil
        then begin
           if MessageDlg('    '
                         + #13 + Trim(Cells[2,Row]),
              mtConfirmation, [mbYes, mbNo], 0) = mrYes
           then begin
             ExpandNode(wNode);
           end;
        end
        else MessageDlg(Trim(Cells[2,Row]) + '    ...',
                        mtInformation, [mbOk], 0);
    end
    else MessageDlg(Trim(Cells[2,Row]) + '    ...',
                    mtInformation, [mbOk], 0);
  end;
end;

//   
procedure TForm1.PUM1SelectClick(Sender: TObject);
var wNode : TTreeNode;
begin
  wNode := TreeView1.Selected;
  if wNode <> nil
  then begin
    wNode.StateIndex := 1;
  end;
end;

//    
procedure TForm1.PUM1DeSelectClick(Sender: TObject);
var wNode : TTreeNode;
begin
  wNode := TreeView1.Selected;
  if wNode <> nil
  then begin
    wNode.StateIndex := -1;
  end;
end;

//       
procedure TForm1.PUM1SaveToFileClick(Sender: TObject);
var sNode  : TTreeNode;
    wNode  : TTreeNode;
    nName  : string;
    wCount : integer;
begin
  sNode := TreeView1.Selected;
  if sNode <> nil
  then begin
    SList.Clear;
    nName := sNode.Text;
    SList.Add('');
    SList.Add(' ' + nName);
    SList.Add('       :');
    SList.Add('');
    wNode := sNode.GetNext;
    wCount := 0;
    while wNode <> nil
    do begin
      if wNode.Level > sNode.Level
      then begin
         SList.Add ( IntToStr(wNode.Level-sNode.Level)
                   + DupeString( #09, (wNode.Level-sNode.Level))
                   + wNode.Text );
         wCount := wCount + 1;
         wNode := wNode.GetNext;
      end else Break;
    end;
    SList.Add('');
    SList.Add('     ' + nName
            + '  ' + IntToStr(wCount));
    if MessageDlg('    ' + nName
                  + #13 + '  : .\Trees\' + nName + '.txt',
       mtConfirmation, [mbYes, mbNo], 0) = mrYes
    then begin
       SList.SaveToFile('.\Trees\' + nName + '.txt');
    end;
  end;
end;

//       Edit1
procedure TForm1.SButtFindClassClick(Sender: TObject);
begin
  if (TreeView1.Items.Count > 0) and (Trim(Edit1.Text) <> '')
  then SeekByNameAndExpandNode(TreeView1, Trim(Edit1.Text));
end;

// -----------------------------------------------------------------------
//    ( 3)
// -----------------------------------------------------------------------
//   TStringList
procedure TForm1.FormCreate(Sender: TObject);
begin
   SList := TStringList.Create;
   SList.Clear;
   StatusBar1.Panels[1].Text := '   ';
end;
//    
procedure TForm1.MM1AboutClick(Sender: TObject);
begin
 AboutBox.Show
end;
//   
procedure TForm1.MM1ExitClick(Sender: TObject);
begin
 Self.Close;
end;
//   TStringList
procedure TForm1.FormDestroy(Sender: TObject);
begin
   SList.Free;
end;

end.



